<?php

class mmf_snippets {
	
	//initiates the class
	public function __construct(){
		add_action( 'admin_init',array($this,'styles'));
	}
	
	//creats a list of stars ifo score - max score
	public function create_stars($score){
		
		$star1 = '<i class="fa fa-star" aria-hidden="true"></i>';
		$star2 = '<i class="fa fa-star-half-o" aria-hidden="true"></i>';
		
		$stars = round( $score * 2, 0, PHP_ROUND_HALF_UP);
				
		$i = 1;
		while ($i <= $stars - 1) {
			echo $star1;
			$i += 2;
		}
		if ( $stars & 1 ) echo $star2;
				
		
	}

	Public function starrating($value,$count,$best,$item,$itemname){
		
		?>
		<div class="stars"><?php echo $this->create_stars($value)?></div>
		<div itemprop="aggregateRating" itemscope="" itemtype="http://schema.org/AggregateRating">
		<span itemprop="ratingValue"><?php echo $value?></span>
		<span itemprop="itemReviewed" itemscope itemtype="http://schema.org/<?php echo $item ?>"><?php echo $itemname?></span>
		<?php _e("op","mailbox-micro-formats")?>
		<span itemprop="bestRating" class="bestRating"><?php echo $best ?></span>
		<?php _e("gebaseerd op laatste ","mailbox-micro-formats")?>
		<span itemprop="ratingCount" class="ratingCount"><?php echo $count ?></span><?php _e(" reviews.","mailbox-micro-formats")?>
		</div>
		<?php 	
	}
	
	//creates a review
	public function create_review($title,$author,$date, $description, $product){
		?>
		<div itemprop="review" itemscope itemtype="http://schema.org/Review">	
			<meta itemprop="description" content="<?php echo $description ?>"/>
			<meta itemprop="itemReviewed" itemscope itemtype="http://schema.org/Thing" content="<?php echo $product ?>" />
			<span itemprop="name"><?php echo $title ?></span>
			<span itemprop="author"><?php echo $author ?></span>
			<span itemprop="datePublished" content="<?php echo $date ?>"><?php echo $date ?></meta>
			<div itemprop="reviewBody"><?php echo $description ?></div>		
		</div>
		<?php
	}
	
	//enqueue styles
	public function styles(){
		wp_register_style('font-awesome-mf', "https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css");
		wp_enqueue_style('font-awesome-mf');
	}

}
